// naumann@stce.rwth-aachen.de

#include "dco.hpp"
#include "newton_sigmoid.hpp"

template<typename T, typename PT>
std::vector<T> gradient(T &x_v, const T &p_v, const T &w_v, const PT &eps, const unsigned int maxit) {
  std::vector<T> g;
  using DCO_M=typename dco::ga1s<T>;
  using DCO_T=typename DCO_M::type;
  using DCO_TT=typename DCO_M::tape_t;
  DCO_T x_readonly=x_v,p=p_v,w=w_v; 
  DCO_M::global_tape=DCO_TT::create();
  DCO_M::global_tape->register_variable(x_readonly);
  DCO_M::global_tape->register_variable(p);
  DCO_M::global_tape->register_variable(w);
  DCO_T x=x_readonly;
  newton(x,p,w,eps,maxit); 
  x_v=dco::value(x);
  dco::derivative(x)=1;
  DCO_M::global_tape->interpret_adjoint();
  g.push_back(dco::derivative(x_readonly)); 
  g.push_back(dco::derivative(p)); 
  g.push_back(dco::derivative(w)); 
  DCO_TT::remove(DCO_M::global_tape);
  return g;
}

#include <iostream>
#include <cassert>

int main(int argc, char *argv[]) {
  assert(argc==6); using T=double; using namespace std;
  T x=stof(argv[1]), p=stof(argv[2]), w=stof(argv[3]), eps=stof(argv[4]); 
  unsigned int maxit=stoi(argv[5]); 
  assert(w>0); assert(eps>0); assert(maxit>0);
  vector<T> g=gradient(x,p,w,eps,maxit);
  cout << "x=" << x << endl;
  cout << "g= [ "; for (const auto& i:g) cout << i << " ";
  cout << "]" << endl;
  return 0;
}

