// naumann@stce.rwth-aachen.de

#include "dco.hpp"
#include "newton_sigmoid.hpp"

template<typename T, typename PT>
std::vector<T> gradient(T &x_v, const T &p_v, const T &w_v, const PT &eps, const unsigned int maxit) {
  std::vector<T> g;
  using DCO_T=typename dco::gt1s<T>::type;
  DCO_T x=x_v,p=p_v,w=w_v;
  // dfdx
  dco::derivative(x)=1; 
  newton(x,p,w,eps,maxit); 
  g.push_back(dco::derivative(x)); 
  // dfdp
  x=x_v; dco::derivative(p)=1; 
  newton(x,p,w,eps,maxit); 
  g.push_back(dco::derivative(x)); 
  // dfdw
  x=x_v; dco::derivative(p)=0; dco::derivative(w)=1; 
  newton(x,p,w,eps,maxit); 
  g.push_back(dco::derivative(x)); 
  x_v=dco::value(x);
  return g;
}

#include <iostream>
#include <cassert>

int main(int argc, char *argv[]) {
  assert(argc==6); using T=double; using namespace std;
  T x=stof(argv[1]), p=stof(argv[2]), w=stof(argv[3]), eps=stof(argv[4]); 
  unsigned int maxit=stoi(argv[5]); 
  assert(w>0); assert(eps>0); assert(maxit>0);
  vector<T> g=gradient(x,p,w,eps,maxit);
  cout << "x=" << x << endl;
  cout << "g= [ "; for (const auto& i:g) cout << i << " ";
  cout << "]" << endl;
  return 0;
}

