// naumann@stce.rwth-aachen.de

#include "newton_sigmoid_t.hpp"

#include <vector>

template<typename T, typename PT>
std::vector<T> gradient(T &x, const T &p, const T &w, const PT &eps, const unsigned int maxit) {
  std::vector<T> g;
  T x_v=x;
  // dfdx
  T x_t=1,p_t=0,w_t=0;
  newton_t(x,x_t,p,p_t,w,w_t,eps,maxit); 
  g.push_back(x_t); 
  // dfdp
  x=x_v; x_t=0,p_t=1,w_t=0;
  newton_t(x,x_t,p,p_t,w,w_t,eps,maxit); 
  g.push_back(x_t); 
  // dfdw
  x=x_v; x_t=0,p_t=0,w_t=1;
  newton_t(x,x_t,p,p_t,w,w_t,eps,maxit); 
  g.push_back(x_t); 
  return g;
}

#include <iostream>
#include <cassert>

int main(int argc, char *argv[]) {
  assert(argc==6); using T=double; using namespace std;
  T x=stof(argv[1]), p=stof(argv[2]), w=stof(argv[3]), eps=stof(argv[4]); 
  unsigned int maxit=stoi(argv[5]); 
  assert(w>0); assert(eps>0); assert(maxit>0);
  vector<T> g=gradient(x,p,w,eps,maxit);
  cout << "x=" << x << endl;
  cout << "g= [ "; for (const auto& i:g) cout << i << " ";
  cout << "]" << endl;
  return 0;
}
