// naumann@stce.rwth-aachen.de

#include<cmath>
#include<iostream>

template<typename T>
void f1(const T &x, T &y) {
  y=sin(x);
}

template<typename T>
void f1_t1(const T &x, const T &x_t1, T &y, T &y_t1) {
  y_t1=cos(x)*x_t1;
  y=sin(x);
}

template<typename T>
void f1_t1_t2(const T &x, const T &x_t2, const T &x_t1, const T &x_t1_t2, T &y, T &y_t2, T &y_t1, T &y_t1_t2) {
  y_t1_t2=-sin(x)*x_t1*x_t2+cos(x)*x_t1_t2;
  y_t1=cos(x)*x_t1;
  y_t2=cos(x)*x_t2;
  y=sin(x);
}

template<typename T>
void f2(const T &x, T &y) {
  y=cos(x);
}

template<typename T>
void f2_t1(const T &x, const T &x_t1, T &y, T &y_t1) {
  y_t1=-sin(x)*x_t1;
  y=cos(x);
}

template<typename T>
void f2_t1_t2(const T &x, const T &x_t2, const T &x_t1, const T &x_t1_t2, T &y, T &y_t2, T &y_t1, T &y_t1_t2) {
  y_t1_t2=-cos(x)*x_t1*x_t2-sin(x)*x_t1_t2;
  y_t1=-sin(x)*x_t1;
  y_t2=-sin(x)*x_t2;
  y=cos(x);
}

template<typename T, typename PT>
void sigmoid(T &x, const PT &p, const PT &w) {
  T a; f1(x,a);
  T b; f2(x,b);
  x=1/(1+exp(-(x-p)/w));
  x=a*(1-x)+b*x;
}

template<typename T, typename PT>
void sigmoid_t1(T &x, T &x_t1, const PT &p, const PT &w) {
  T a, a_t1;
  f1_t1(x,x_t1,a,a_t1);
  T b, b_t1;
  f2_t1(x,x_t1,b,b_t1);
  T c_t1=-exp(-(x-p)/w)/w*x_t1;
  T c=1+exp(-(x-p)/w);
  x_t1=-c_t1/pow(c,2);
  x=1/c;
  x_t1=(1-x)*a_t1+(b-a)*x_t1+x*b_t1;
  x=a*(1-x)+b*x;
}

template<typename T, typename PT>
void sigmoid_t1_t2(T &x, T &x_t2, T &x_t1, T &x_t1_t2, const PT &p, const PT &p_t2, const PT &w, const PT &w_t2) {
  T a,a_t1,a_t2,a_t1_t2;
  f1_t1_t2(x,x_t2,x_t1,x_t1_t2,a,a_t2,a_t1,a_t1_t2);
  T b,b_t1,b_t2,b_t1_t2;
  f2_t1_t2(x,x_t2,x_t1,x_t1_t2,b,b_t2,b_t1,b_t1_t2);
  T aux=exp(-(x-p)/w);
  T aux_t2=-aux/w*x_t2+aux/w*p_t2+aux*(x-p)/pow(w,2)*w_t2;
  T c_t1_t2=-aux_t2/w*x_t1+aux/pow(w,2)*x_t1*w_t2-aux/w*x_t1_t2;
  T c_t1=-aux/w*x_t1;
  T c_t2=aux_t2;
  T c=1+aux;
  x_t1_t2=-c_t1_t2/pow(c,2)+2*c_t1/pow(c,3)*c_t2;
  x_t1=-c_t1/pow(c,2);
  x_t2=-c_t2/pow(c,2);
  x=1/c;
  x_t1_t2=-a_t1*x_t2+(1-x)*a_t1_t2+x_t1*b_t2-x_t1*a_t2+(b-a)*x_t1_t2+b_t1*x_t2+x*b_t1_t2;
  x_t1=(1-x)*a_t1+(b-a)*x_t1+x*b_t1;
  x_t2=(1-x)*a_t2+(b-a)*x_t2+x*b_t2;
  x=a*(1-x)+b*x;
}

template<typename T, typename PT>
void dsigmoid_dx_t(T &x, T &x_t, const PT &p, const PT &p_t, const PT &w, const PT &w_t, T &dx, T &dx_t) {
  dx_t=0; dx=1; sigmoid_t1_t2(x,x_t,dx,dx_t,p,p_t,w,w_t);
}

template<typename T, typename PT>
void newton_t(T &x, T &x_t, const T &p, const T &p_t, const T &w, const T &w_t, const PT &eps, const unsigned int maxit) {
  unsigned int it=0;
  T y_t=x_t, dy_t;
  T y=x, dy;
  dsigmoid_dx_t(y,y_t,p,p_t,w,w_t,dy,dy_t);
  do {
    x_t=x_t-(y_t/dy-y/pow(dy,2)*dy_t);
    x=x-y/dy;
    y_t=x_t; 
    y=x;
    dsigmoid_dx_t(y,y_t,p,p_t,w,w_t,dy,dy_t);
    if (++it==maxit) break;
  } while(fabs(y)>eps);
}
