// naumann@stce.rwth-aachen.de

#include<cmath>
#include<iostream>

template<typename T>
void f1(const T &x, T &y) {
  y=sin(x);
}

template<typename T>
void f1_t(const T &x, const T &x_t, T &y, T &y_t) {
  y_t=cos(x)*x_t;
  y=sin(x);
}

template<typename T>
void f2(const T &x, T &y) {
  y=cos(x);
}

template<typename T>
void f2_t(const T &x, const T &x_t, T &y, T &y_t) {
  y_t=-sin(x)*x_t;
  y=cos(x);
}

template<typename T, typename PT>
void sigmoid(T &x, const PT &p, const PT &w) {
  T a; f1(x,a);
  T b; f2(x,b);
  x=1/(1+exp(-(x-p)/w));
  x=a*(1-x)+b*x;
}

template<typename T, typename PT>
void sigmoid_t(T &x, T &x_t, const PT &p, const PT &w) {
  T a, a_t;
  f1_t(x,x_t,a,a_t);
  T b, b_t;
  f2_t(x,x_t,b,b_t);
  T c_t=-exp(-(x-p)/w)/w*x_t;
  T c=1+exp(-(x-p)/w);
  x_t=-c_t/pow(c,2);
  x=1/c;
  x_t=(1-x)*a_t+(b-a)*x_t+x*b_t;
  x=a*(1-x)+b*x;
}

template<typename T, typename PT>
void dsigmoid_dx(T &x, const PT &p, const PT &w, T &dx) {
  dx=1; sigmoid_t(x,dx,p,w);
}

template<typename T, typename PT>
void newton(T &x, const T &p, const T &w, const PT &eps, const unsigned int maxit) {
  unsigned int it=0;
  T y=x, dy;
  dsigmoid_dx(y,p,w,dy);
  do {
    x-=y/dy;
    y=x;
    dsigmoid_dx(y,p,w,dy);
    if (++it==maxit) break;
  } while(fabs(y)>eps);
}
