// naumann@stce.rwth-aachen.de

#include "newton_sigmoid_a.hpp"

#include <vector>

template<typename T, typename PT>
std::vector<T> gradient(T &x, const T &p, const T &w, const PT &eps, const unsigned int maxit) {
  std::vector<T> g;
  T x_a=1,p_a=0,w_a=0;
  newton_a(x,x_a,p,p_a,w,w_a,eps,maxit); 
  g.push_back(x_a); 
  g.push_back(p_a); 
  g.push_back(w_a); 
  return g;
}

#include <iostream>
#include <cassert>

int main(int argc, char *argv[]) {
  assert(argc==6); using T=double; using namespace std;
  T x=stof(argv[1]), p=stof(argv[2]), w=stof(argv[3]), eps=stof(argv[4]); 
  unsigned int maxit=stoi(argv[5]); 
  assert(w>0); assert(eps>0); assert(maxit>0);
  vector<T> g=gradient(x,p,w,eps,maxit);
  cout << "x=" << x << endl;
  cout << "g= [ "; for (const auto& i:g) cout << i << " ";
  cout << "]" << endl;
  return 0;
}
