// naumann@stce.rwth-aachen.de

#pragma once

#include<vector>
#include<cmath>

#include "f0_dch.hpp"

#include "newton.hpp"

#include "f1_f2.hpp"

template<typename T, typename PT>
void steps(size_t j, size_t from, size_t to, T& x, const std::vector<T>& p, const std::vector<std::vector<PT>>& dW) {
  size_t n=p.size()-2;
  T dt=1./n, t=from*dt;
  for (size_t i=from;i<to;i++) {
    T xt=x*t;
    x+=dt*p[i]*f1(xt)+p[i]*f2(xt)*sqrt(dt)*dW[j][i];
    t+=dt;
  }
}

template<typename T, typename PT>
void paths(size_t ncs, size_t from, size_t to, T& x, const std::vector<T>& p, const std::vector<std::vector<PT>>& dW, T& s) { 
  using namespace std;
  size_t n=p.size()-2;
  T x0=x;
  for (size_t j=from;j<to;j++) {
    for (size_t i=0;i<n;i+=ncs) steps(j,i,i+ncs,x,p,dW);
    T sig=1/(1+exp(-(x-p[n])/p[n+1])); s+=(x-p[n])*sig; x=x0;
  }
}

template<typename T, typename PT>
void f(size_t ncp, size_t ncs, const PT &eps, T& x, const std::vector<T>& p, const std::vector<std::vector<PT>>& dW) { 
  newton(x,p[0],eps);
  T s=0; 
  size_t m=dW.size();
  for (size_t j=0;j<m;j+=ncp) paths(ncs,j,j+ncp,x,p,dW,s);
  x=s/m;
}
