// naumann@stce.rwth-aachen.de

#include "f.hpp"

#include "dco.hpp"

#include <vector>

template<int N=1, typename T, typename PT>
void gradient(size_t ncp, size_t ncs, const PT &eps, T& x_v, std::vector<T>& p_v, const std::vector<std::vector<PT>> &dW, std::vector<T> &dxdp) {
  using DCO_M=typename dco::ga1v<T,N>;
  using DCO_T=typename DCO_M::type;
  using DCO_TT=typename DCO_M::tape_t;
  size_t n=p_v.size(); 
  DCO_T x=x_v;  std::vector<DCO_T> p(n); dco::value(p)=p_v; 
  DCO_M::global_tape=DCO_TT::create();
  DCO_M::global_tape->register_variable(p);
  f(ncp,ncs,eps,x,p,dW);
  x_v=dco::value(x);
  DCO_M::global_tape->register_output_variable(x);
  dco::derivative(x)[0]=1;
  DCO_M::global_tape->interpret_adjoint();
  for (size_t i=0;i<n;i++) dxdp[i]=dco::derivative(p[i])[0];
  DCO_TT::remove(DCO_M::global_tape);
}  

#include "g_main.hpp"

