// naumann@stce.rwth-aachen.de

#pragma once

#include <cassert>
#include <vector>
#include <random>
#include <iostream>

int main(int argc, char* argv[]) {
  assert(argc==7);
  using T=double; using PT=float; using namespace std;
  size_t m=stoi(argv[1]), n=stoi(argv[2])+2, ncp=stoi(argv[3]), ncs=stoi(argv[4]);
  assert(m%ncp==0); assert((n-2)%ncs==0);
  PT eps=stof(argv[5]);
  T x=1; vector<T> p(n,1), dxdp(n,0);
  p[n-1]=stof(argv[6]);
  vector<vector<PT>> dW(m,vector<PT>(n-2,1));
  default_random_engine g; normal_distribution<PT> d(0.0,1.0);
  for (auto &r:dW) for (auto &c:r) c=d(g);
  gradient(ncp,ncs,eps,x,p,dW,dxdp);
  cout << "x=" << x << endl;
  for (size_t i=0;i<n;i++) 
    cout << "dx/dp[" << i << "]=" << dxdp[i] << endl;
  return 0;
}
