// naumann@stce.rwth-aachen.de

#pragma once

#include<cmath>

template<typename T, typename PT>
void newton(T& x, const T& p, const PT& eps) {
  do {
    x=x-df0dx(x,p)/ddf0dxx(x,p);
  } while (fabs(df0dx(x,p))>eps);
}
