#include <iostream>
#include <fstream>
#include "Eigen/Dense" 

template<typename T, int N=Eigen::Dynamic>
void f(const Eigen::Matrix<T,N,1>& x, T& y) {
  y=x.transpose()*Eigen::Matrix<T,N,1>::Ones(x.size())+(x*x.transpose()).cwiseProduct(x*x.transpose()).sum();
} 

template<typename T, int N=Eigen::Dynamic>
void dfdx(const Eigen::Matrix<T,N,1>& x, Eigen::Matrix<T,N,1>& dydx) {
  auto n=x.size();
  dydx=Eigen::Matrix<T,N,1>::Ones(n)+4*x.dot(x)*x;
}

template<typename T, int N=Eigen::Dynamic>
void ddfdxx(const Eigen::Matrix<T,N,1>& x, Eigen::Matrix<T,N,N>& ddydxx) {
  ddydxx=8*x*x.transpose()+4*x.dot(x)*Eigen::Matrix<T,N,N>::Identity(x.size(),x.size());
}

template<typename T, int N=Eigen::Dynamic>
void Newton(Eigen::Matrix<T,N,1>& x, const T eps) {
  std::ofstream fout("data"); T y;
  auto n=x.size();
  Eigen::Matrix<T,N,1> dydx(n); 
  dfdx(x,dydx);
  do {
    f(x,y); fout << x.transpose() << " " << y << std::endl;
    std::cout << ".";
    Eigen::Matrix<T,N,N> ddydxx(n,n); 
    ddfdxx(x,ddydxx);
    x+=ddydxx.llt().solve(-dydx);
    dfdx(x,dydx);
  } while (dydx.norm()>eps);
  std::cout << std::endl;
  f(x,y); fout << x.transpose() << " " << y << std::endl;
  fout.close();
}

int main(int, char* v[]) {
  int n=std::stoi(v[1]);
  using VT=Eigen::Matrix<double,Eigen::Dynamic,1>;
  using MT=Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic>;
  VT x=VT::Random(n);
  std::cout << "x0=" << x.transpose() << std::endl;
  Newton(x,1e-12);
  std::cout << "x*=" << x.transpose() << std::endl;
  double y;
  f(x,y);
  std::cout << "y=" << y << std::endl;
  VT dydx(n);
  dfdx(x, dydx);
  std::cout << "||dfdx||=" << dydx.norm() << std::endl;
  MT ddydxx(n,n);
  ddfdxx(x,ddydxx);
  std::cout << "||ddfdxx||=" << ddydxx.norm() << std::endl;
  return 0;
}
