#include <iostream>
#include "Eigen/Dense" 

template<typename T, int N=Eigen::Dynamic>
void F(const Eigen::Matrix<T,N,1>& x, Eigen::Matrix<T,N,1>& y) {
  auto n=x.size();
  y=Eigen::Matrix<T,N,1>::Ones(n)+4*x.dot(x)*x;
}

template<typename T, int N=Eigen::Dynamic>
void dFdx(const Eigen::Matrix<T,N,1>& x, Eigen::Matrix<T,N,N>& dydx) {
  dydx=8*x*x.transpose()+4*x.dot(x)*Eigen::Matrix<T,N,N>::Identity(x.size(),x.size());

}

template<typename T, int N=Eigen::Dynamic>
void Newton(Eigen::Matrix<T,N,1>& x, const T eps) {
  auto n=x.size();
  Eigen::Matrix<T,N,1> y(n); 
  F(x,y);
  do {
    std::cout << ".";
    Eigen::Matrix<T,N,N> dydx(n,n); 
    dFdx(x,dydx);
    x+=dydx.partialPivLu().solve(-y);
    F(x,y);
  } while (y.norm()>eps);
  std::cout << std::endl;
}

int main(int, char* v[]) {
  int n=std::stoi(v[1]);
  using VT=Eigen::Matrix<double,Eigen::Dynamic,1>;
  using MT=Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic>;
  VT x=VT::Random(n);
  std::cout << "x0=" << x.transpose() << std::endl;
  Newton(x,1e-12);
  std::cout << "x*=" << x.transpose() << std::endl;
  VT y(n);
  F(x,y);
  std::cout << "||y||=" << y.norm() << std::endl;
  MT dydx(n,n);
  dFdx(x, dydx);
  std::cout << "||dFdx||=" << dydx.norm() << std::endl;
  return 0;
}
